import java.net.*;
import java.io.*;

public class Server
{
  public static void main(String args[])
  {
    ServerSocket serverSocket = null;
    Socket socket = null;
    BufferedReader brinp = null;
    DataOutputStream out = null;
    try{
      serverSocket = new ServerSocket(6666);
    }
    catch(IOException e){
      System.out.println(
        "Bd przy tworzeniu gniazda serwerowego.");
      System.exit(-1);
    }
    System.out.println("Inicjalizacja gniazda zakoczona...");
    System.out.println("Parametry gniazda: " + serverSocket);
    try{
      System.out.println("Trwa oczekiwanie na poczenie...");
      socket = serverSocket.accept();
    }
    catch(IOException e){
      System.out.println(e);
      System.exit(-1);
    }
    System.out.println("Nadeszo poczenie...");
    System.out.println("Parametry poczenia: " + socket);
    try{
      System.out.println("Inicjalizacja strumieni...");
      brinp = new BufferedReader(
        new InputStreamReader(
          socket.getInputStream()
        )
      );
      out = new DataOutputStream(socket.getOutputStream());
    }
    catch(IOException e){
      System.out.println("Bd przy tworzeniu strumieni.");
      System.exit(-1);
    }
    System.out.println("Zakoczona inicjalizacja strumieni...");
    System.out.println("Rozpoczcie ptli gwnej...");
    while(true){
      try{
        String line = brinp.readLine();
        System.out.println("Odczytano lini: " + line);
        if(line == null || "quit".equals(line)){
          try{
            socket.close();
            serverSocket.close();
          }
          catch(IOException e){
            System.out.println(
              "Bd przy zamykaniu gniazda serwerowego.");
          }
          System.out.println("Zakoczenie pracy...");
          System.exit(0);
        }
        out.writeBytes(line + "\n\r");
        System.out.println("Wysano lini: " + line);
      }
      catch(IOException e){
        System.out.println("Bd wejcia-wyjcia.");
        System.exit(-1);
      }
    }
  }
}
